---
type: constant
tags:
  - "#layer/translation"
  - "#status/stable"
  - "#function/definition"
polarity: P0
aliases:
  - ε
  - Epsilon
  - Difference Resolution Quantum
---

# ε — Difference Resolution Quantum (constant)

> Minimal perceivable or actionable unit of difference; sets the system's structural "pixel size."

---

## Definition (concept)

- Symbol: ε
- Conceptual name: Difference Resolution Quantum
- Conceptual value: conceptual (domain instances carry numbers/units)
- Definition: smallest unit of difference that can propagate across an interface without collapsing

---

## Derivation from Base Constants

ε emerges directly from **A1 — Irreducibility (axiom)**:

**From A1:** Primitive difference (∆) cannot be decomposed without loss of distinction
- This irreducibility requires a **minimal quantum** below which differences cannot be meaningfully distinguished
- ε represents this fundamental resolution limit for the system
- **Domain instantiation:** Physics (ħ), Computing (1 bit), Biology (minimal signal threshold)

**Axiom Foundation:** A1 establishes that there must be an irreducible unit of difference - ε quantifies this limit.

---

## Dual‑register mapping (concept)

Map the constant into both registers and show the bridge explicitly.

### Technical (network/computational)

| Constant concept | Network construct (Target) | Interface/API example |
|-----------------|---------------------------|----------------------|
| Resolution | Minimum step size | `MinimalDifference` |
| Threshold | Signal quantization | `QuantumThreshold` |
| Precision | Machine epsilon | `FloatEpsilon` |

### Humane (biological/relational)

| Constant concept | Humane construct (Target) | Example |
|-----------------|---------------------------|---------|
| Resolution | Just-noticeable difference | When a taste becomes distinct |
| Threshold | Attention quantum | Smallest change we can notice |
| Precision | Care threshold | Smallest difference that matters |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Step size | Noticeable change | Minimal meaningful difference |
| Quantization | Attention grain | How finely we can distinguish |
| Epsilon | Care threshold | What counts as different |

---

## Domain Mapping

Brief examples across domains showing both technical and humane angles:

| Domain | Technical manifestation | Humane manifestation |
|--------|------------------------|---------------------|
| Physics | Planck constant (h) | Quantum of action |
| Chemistry | Bond energy quantum | Reaction threshold |
| Biology | Gene mutation unit | Phenotype distinction |
| Social | Bit of information | Meaningful signal |
| Economy | Price tick size | Perceived value change |
| Politics | Vote quantum | Individual agency |
| Networks | Bit flip | State transition |
| Cognition | Neural threshold | Conscious distinction |

---

## Formal identity (concept)

Domain instantiations:
- Physics: $\varepsilon_{phys} \equiv h$ (or $\hbar$), with $E = h\,\nu$
- Computing: $\varepsilon_{info} \equiv 1\,\text{bit}$, distinguishing 2 states $\log_2 2 = 1$

---

## Anchor role

- Sets the granularity at which differences are countable/actionable
- Normalizes thresholds, sampling, and minimal transactions across domains

---

## Scope & invariance

- ε is a conceptual anchor; concrete value is domain‑specific
- Physics: fixed by fundamental constants and units
- Computing: fixed by encoding and channel model
- Choose ε explicitly per domain to avoid category errors

---

## Interplay with SVA (if relevant)

- ∇S (Structure): chooses partitioning granularity; finer ε → deeper feasible embeddings
- λV (Void): ε sets the minimum signal that clears the gate
- ψA (Awareness): ε informs memory/time‑step needed to retain a difference

---

## Instances (domain bindings)

- Physics: [[ħ — Reduced Planck Constant (constant)|ħ — Reduced Planck Constant]]
- Computing: 1 bit — minimal informational difference unit

---

## See Also

- [[π — Closure Geometry Ratio (constant)]]
- [[e — Natural Transformation Rate (constant)]]
- [[φ — Asymmetric Stabilization Ratio (constant)]]
- [[c — Difference Propagation Limit (constant)]]
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]
- [[λV — Void Resonance Threshold (Volozhina)]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included